;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                 ;
; qauth.mrc - A QuakeNet AUTH and login script    ;
; Version 0.80                                   ;
;                                                 ;
; Written by SubSpace <subspace@subbot.net>       ;
; Original by teh Zlutteh :<                      ;
;                                                 ;
; http://www.subbot.net/mirc/qauth/               ;
;                                                 ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                 ;
; Yes, the layout of this script is ugly,         ;
; please send complaints to Khaled :>             ;
;                                                 ;
; How to install this garbage?                    ;
; ----------------------------                    ;
; * Place this file in your mIRC directory        ;
; * Run this command in mIRC: /load -rs qauth.mrc ;
; * Allow initialization commands                 ;
; * Fill in the dialog. You will need a Q account ;
;   for this script to be of any use. See the     ;
;   Q FAQ on http://www.quakenet.org/             ;
;                                                 ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

dialog QuakeNetAuthDlg {
  title "QuakeNet Login configuration"
  size -1 -1 150 210
  option map
  combo 2, 8 101 96 85, size
  button "OK", 3, 70 192 38 14, default ok
  button "Cancel", 4, 109 192 38 14, cancel
  button "Add", 5, 106 101 36 12, default
  text "Channels to join:", 6, 8 91 60 8
  edit %QuakenetAuthTime, 7, 77 79 20 10
  text "seconds", 8, 99 79 28 8
  button "Remove", 9, 106 114 36 12, default
  check "Hide IP/hostname (mode +x)", 10, 4 24 138 10
  text "AUTH name:", 11, 4 4 55 8
  text "AUTH password:", 12, 4 13 55 8
  edit %QuakenetAuthName, 13, 62 3 60 10
  edit %QuakenetAuthPass, 14, 62 13 60 10, pass
  box "Auto Join channels", 15, 4 69 142 121
  text "Q response timeout:", 1, 8 79 68 9
  link "Website / about", 16, 8 195 64 8
  check "Check server connection (every minute)", 17, 4 34 138 10
  check "Use HMAC-SHA-256 challengeauth", 18, 4 44 138 10
  button "Up", 19, 106 140 24 14
  button "Down", 20, 106 155 24 14
  check "I'm using an IRC Bouncer (like psyBNC)", 21, 4 54 138 10
}

menu menubar,status {
  QuakeNet configuration:QuakenetConfigure
}

alias -l QuakenetCheckConnection {
  .raw PONG
}

alias -l QuakenetStartConnectionCheck {
  var %i = $scon(0)
  while (%i >= 0) {
    if ($scon(%i).network == QuakeNet && $scon(%i).status == connected) {
      scon %i .timer 0 60 QuakenetCheckConnection
    }
    dec %i
  }
}

alias -l QuakenetStopConnectionCheck {
  ; Remove any connection check timers
  var %i = $timer(0)
  while (%i >= 0) {
    if ($timer(%i).com == QuakenetCheckConnection) {
      .timer $+ $timer(%i) off
    }
    dec %i
  }
}

alias QuakenetSendAuth {
  if (%QuakenetChallengeAuth == 1) {
    echo 4*** Requesting challenge.
    .msg Q@Cserve.quakenet.org CHALLENGE %QuakenetAuthName
    if (%QuakenetFakeHost == 1) { mode $me +x }
  }
  else {
    .msg Q@Cserve.quakenet.org AUTH %QuakenetAuthName %QuakenetAuthPass
    echo 4*** AUTH information sent.
    if (%QuakenetFakeHost == 1) { mode $me +x }
  }

  QuakenetDelayedJoinChannels
}

alias QuakenetDelayedJoinChannels {
  .timer 1 %QuakenetAuthTime QuakenetJoinChannels
  set %QuakenetTimerId $ltimer
}

alias QuakenetCancelJoinChannels {
  if (%QuakenetTimerId != $null) {
    .timer $+ %QuakenetTimerId off
    unset %QuakenetTimerId
  }
}

alias QuakenetJoinChannels {
  echo 4*** $iif($1- != $null,$1- $+ $chr(44) j, J) $+ oining channels ( $+ %QuakenetChannels $+ )
  QuakenetCancelJoinChannels

  ; Split channel list, send join command every time we encounter a channel with specified key
  ; as only the last channel in the list can have a key specified :(
  var %channels = %QuakenetChannels
  var %f, %tojoin, %channel
  while ($len(%channels) > 0) {
    %f = $pos(%channels,$chr(44),1)
    if (%f == $null) {
      %tojoin = %tojoin $+ $iif($len(%tojoin) > 0,$chr(44),) $+ %channels
      %channels =
    }
    else {
      %channel = $left(%channels,$calc(%f - 1))
      %channels = $mid(%channels,$calc(%f + 1),$calc($len(%channels) - %f))
      %tojoin = %tojoin $+ $iif($len(%tojoin) > 0,$chr(44),) $+ %channel

      if ($pos(%channel,$chr(32),1) != $null) {
        join %tojoin
        %tojoin =
      }
    }
  }
  ; Join remaining channels
  if ($len(%tojoin) > 0) {
    join %tojoin
  }

  ;join %QuakenetChannels
}

alias -l IsQuakenet {
  if ($right($server,13) == .quakenet.org) {
    return 1
  }
  else {
    return $null
  }
}

ON *:NOTICE:AUTH'd successfully.:?: {
  if ($nick == Q && %QuakenetFakeHost != 1 && $IsQuakenet) {
    QuakenetJoinChannels
  }
}

ON *:NOTICE:CHALLENGEAUTH'd successfully.:?: {
  if ($nick == Q && %QuakenetFakeHost != 1 && $IsQuakenet) {
    QuakenetJoinChannels
  }
}

ON ^*:NOTICE:You are already authed.:?: {
  if ($nick == Q && %QuakenetBouncerMode && $IsQuakenet) {
    ;echo 4 Reconnecting to bouncer, skipping channel join
    QuakenetCancelJoinChannels
    haltdef
  }
}

ON ^*:NOTICE:CHALLENGE *HMAC-SHA-256*:?: {
  if ($nick == Q && $IsQuakenet) {
    .msg Q@Cserve.quakenet.org CHALLENGEAUTH %QuakenetAuthName $AuthHmacSha256(%QuakenetAuthName,%QuakenetAuthPass,$2) HMAC-SHA-256
    echo 4*** CHALLENGEAUTH information sent.
    haltdef
  }
}

alias -l AuthHmacSha256 {
  var %passhash = $sha256($left($2,10))
  var %key = $sha256($lower($1) $+ : $+ %passhash)
  return $hmac($3, %key2, sha256)
}

ON *:NOTICE:Challenge has either not been requested or has expired.:?: {
  if ($nick == Q && $IsQuakenet) {
    QuakenetSendAuth
  }
}

ON *:NOTICE:Either you haven't requested a challenge yet or your one expired.:?: {
  ; Old text for this NOTICE. I don't think it's used anymore
  if ($nick == Q && $IsQuakenet) {
    QuakenetSendAuth
  }
}

RAW 396:*: {
  if (%QuakeNetFakeHost == 1 && $2 == %QuakenetAuthName $+ .users.quakenet.org && $IsQuakenet) {
    QuakenetCancelJoinChannels
    QuakenetJoinChannels $2-
    halt
  }
}

ON 1:START: {
  echo 4*** QAuth 0.80 loaded - http://www.subbot.net/mirc/qauth/
  if (%QuakenetAuthName == $null || %QuakenetAuthPass == $null || %QuakenetAuthTime == $null) {
    QuakenetConfigure
  }

  ; Start connection check for already active QuakeNet connections
  QuakenetStopConnectionCheck
  if (%QuakenetCheckConn == 1) { QuakenetStartConnectionCheck }
}

ON *:CONNECT: {
  ;echo 7 OnConnect: $IsQuakenet $IsQuakenet()
  if ($IsQuakenet && !%QuakenetBouncerMode) {
    QuakenetSendAuth
    if (%QuakenetCheckConn == 1) { .timer 0 60 QuakenetCheckConnection }
  }
}

RAW 001:*: {
  if ($IsQuakenet && %QuakenetBouncerMode) {
    QuakenetSendAuth
    ; Disabled connection check for bouncer mode
    if (%QuakenetCheckConn == 1) { .timer 0 60 QuakenetCheckConnection }
  }
}

ON 1:UNLOAD: {
  echo 4*** QAuth unloading
  QuakenetStopConnectionCheck
}

alias QuakenetConfigure {
  ; Set some defaults
  if (%QuakenetAuthTime == $null) { set %QuakenetAuthTime 20 }
  if (%QuakeNetFakeHost == $null) { set %QuakeNetFakeHost 1 }
  if (%QuakeNetChallengeAuth == $null) { set %QuakeNetChallengeAuth 1 }

  ; Make dialog
  dialog -mo qauthdlg QuakeNetAuthDlg

  ; Set checkboxes if needed
  if (%QuakeNetFakeHost == 1) { did -c qauthdlg 10 }
  if (%QuakeNetCheckConn == 1) { did -c qauthdlg 17 }
  if (%QuakeNetChallengeAuth == 1) { did -c qauthdlg 18 }
  if (%QuakeNetBouncerMode == 1) { did -c qauthdlg 21 }

  ; Fill channel list
  var %channels = %QuakenetChannels
  var %f
  while ($len(%channels) > 0) {
    %f = $pos(%channels,$chr(44),1)
    if (%f == $null) {
      did -a qauthdlg 2 %channels
      %channels =
    }
    else {
      did -a qauthdlg 2 $left(%channels,$calc(%f - 1))
      %channels = $mid(%channels,$calc(%f + 1),$calc($len(%channels) - %f))
    }
  }
}

ON 1:DIALOG:qauthdlg:*:*: {
  if ($devent == mouse) {
    ; Ignore mouse movement events
  }
  elseif ($devent == sclick && $did == 5) {
    ; Add button
    var %channel = $did(qauthdlg,2).text
    if ($len(%channel) > 0 && $left(%channel,1) == $chr(35)) {
      did -a qauthdlg 2 %channel
      did -d qauthdlg 2 0
    }
  }
  elseif ($devent == sclick && $did == 9) {
    ; Remove button
    var %count = $did(qauthdlg,2,0).sel
    while (%count > 0) {
      did -d qauthdlg 2 $did(qauthdlg,2,%count).sel
      dec %count
    }
    did -d qauthdlg 2 0
  }
  elseif ($devent == sclick && $did == 19) {
    ; Up button
    if ($did(qauthdlg,2,0).sel != 1) { return }
    var %selLine = $did(qauthdlg,2,1).sel
    if (%selLine <= 1) { return }
    var %temp = $did(qauthdlg,2,$calc(%selLine - 1)).text

    did -d qauthdlg 2 $calc(%selLine - 1)
    did -i qauthdlg 2 %selLine %temp
  }
  elseif ($devent == sclick && $did == 20) {
    ; Down button
    if ($did(qauthdlg,2,0).sel != 1) { return }
    var %selLine = $did(qauthdlg,2,1).sel
    if (%selLine == $did(qauthdlg,2).lines) { return }
    var %temp = $did(qauthdlg,2,$calc(%selLine + 1)).text

    did -d qauthdlg 2 $calc(%selLine + 1)
    did -i qauthdlg 2 %selLine %temp
  }
  elseif ($devent == sclick && $did == 3) {
    ; OK button
    set %QuakenetAuthName $did(qauthdlg,13).text
    set %QuakenetAuthPass $did(qauthdlg,14).text
    set %QuakenetFakeHost $did(qauthdlg,10).state
    set %QuakenetChallengeAuth $did(qauthdlg,18).state
    set %QuakenetBouncerMode $did(qauthdlg,21).state

    if (%QuakenetCheckConn != $did(qauthdlg,17).state) {
      set %QuakenetCheckConn $did(qauthdlg,17).state
      if (%QuakenetCheckConn == 1) {
        QuakenetStartConnectionCheck
      }
      else {
        QuakenetStopConnectionCheck
      }
    }

    set %QuakenetCheckConn $did(qauthdlg,17).state
    set %QuakenetAuthTime $int($did(qauthdlg,7).text)
    var %channels
    var %i = 1
    var %count = $did(qauthdlg,2,0).lines
    while (%i <= %count) {
      %channels = %channels $+ $did(qauthdlg,2,%i).text $+ ,
      inc %i
    }
    set %QuakenetChannels $left(%channels,$calc($len(%channels) - 1))
  }
  elseif ($devent == sclick && $did == 16) {
    ; Website link
    url -an http://www.subbot.net/mirc/qauth/
  }
  else {
    ;echo $dname $devent $did
  }
}
